import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay_agent/core/helper/date_converter.dart';
import 'package:viserpay_agent/core/helper/string_format_helper.dart';
import 'package:viserpay_agent/core/utils/dimensions.dart';
import 'package:viserpay_agent/core/utils/my_color.dart';
import 'package:viserpay_agent/core/utils/style.dart';
import 'package:viserpay_agent/data/controller/home/home_controller.dart';
import 'package:viserpay_agent/data/model/home/home_response_model.dart';
import 'package:viserpay_agent/view/components/column_widget/card_column.dart';

class LatestTransactionCard extends StatelessWidget {
  final int index;
  final bool isShowDivider;
  final VoidCallback press;

  const LatestTransactionCard({super.key, required this.index, required this.press, this.isShowDivider = true});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<HomeController>(
      builder: (controller) {
        LatestTrx transaction = controller.trxList[index];
        return GestureDetector(
          onTap: press,
          child: Container(
            width: MediaQuery.of(context).size.width,
            padding: const EdgeInsets.symmetric(vertical: Dimensions.space15, horizontal: Dimensions.space10),
            decoration: BoxDecoration(
              color: MyColor.getCardBgColor(),
            ),
            child: Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                Expanded(
                  child: Row(
                    children: [
                      Container(
                        height: 35,
                        width: 35,
                        alignment: Alignment.center,
                        child: Container(
                          height: 35,
                          width: 35,
                          decoration: BoxDecoration(
                            color: transaction.trxType == "-" ? MyColor.colorRed.withOpacity(0.2) : MyColor.colorGreen.withOpacity(0.2),
                            shape: BoxShape.circle,
                          ),
                          child: Icon(
                            transaction.trxType == "-" ? Icons.arrow_upward : Icons.arrow_downward,
                            color: transaction.trxType == "-" ? MyColor.colorRed : MyColor.colorGreen,
                            size: 20,
                          ),
                        ),
                      ),
                      const SizedBox(width: Dimensions.space10),
                      Expanded(
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Text(
                              "${transaction.remark}".replaceAll("_", " ").toTitleCase().tr,
                              style: regularDefault.copyWith(color: MyColor.getTextColor(), fontWeight: FontWeight.w500),
                              maxLines: 1,
                              overflow: TextOverflow.ellipsis,
                            ),
                            const SizedBox(height: Dimensions.space5),
                            SizedBox(
                              width: 150,
                              child: Text(
                                transaction.trx.toString(),
                                style: regularSmall.copyWith(color: MyColor.getTextColor().withOpacity(0.5)),
                                overflow: TextOverflow.ellipsis,
                                maxLines: 2,
                              ),
                            )
                          ],
                        ),
                      )
                    ],
                  ),
                ),
                Expanded(
                  child: CardColumn(
                    header: "${transaction.trxType}${controller.defaultCurrencySymbol}${Converter.formatNumber(transaction.amount.toString())}",
                    body: DateConverter.formatDateMonthYear(transaction.createdAt.toString()),
                    alignmentEnd: true,
                    headerTextDecoration: boldDefault.copyWith(
                      color: transaction.trxType == "-" ? MyColor.colorRed : MyColor.colorGreen,
                      fontSize: Dimensions.fontMediumLarge - 1,
                      fontWeight: FontWeight.w500,
                    ),
                    bodyTextDecoration: lightMediumLarge.copyWith(color: MyColor.colorGrey, fontSize: Dimensions.fontDefault - 1),
                  ),
                )
              ],
            ),
          ),
        );
      },
    );
  }
}
